/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.IVWParamExpressionCellEditorTableModel;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellItem;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class VWOperationParameterTableModel
extends AbstractTableModel
implements IVWParamExpressionCellEditorTableModel {
    public static final int NUM_COLUMNS = 4;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_MODE = 2;
    public static final int COL_VALUE = 3;
    private static final String s_array = "[ ]";
    private VWStepDefinition m_stepDefinition = null;
    private VWParameterDefinition[] m_rowData = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private ImageIcon[] m_modeIcons = null;

    public VWOperationParameterTableModel(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_modeIcons = new ImageIcon[3];
            this.m_modeIcons[0] = VWImageLoader.createImageIcon("read_only.gif");
            this.m_modeIcons[1] = VWImageLoader.createImageIcon("write_only.gif");
            this.m_modeIcons[2] = VWImageLoader.createImageIcon("read_write.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWStepDefinition stepDefinition, VWParameterDefinition[] paramDefs) {
        try {
            this.m_stepDefinition = stepDefinition;
            this.m_rowData = paramDefs;
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWParameterDefinition getItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.length) {
            return null;
        }
        if (nRowIndex < this.m_rowData.length) {
            return this.m_rowData[nRowIndex];
        }
        return null;
    }

    public int getParameterType(int nRowIndex) {
        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getDataType();
        }
        return -1;
    }

    public boolean getIsArray(int nRowIndex) {
        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getIsArray();
        }
        return false;
    }

    public int getMode(int nRowIndex) {
        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getMode();
        }
        return -1;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 2: {
                return VWToolTipTableCellItem.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
            case 1: {
                return VWResource.s_typeStr;
            }
            case 3: {
                return VWResource.s_expressionStr;
            }
            case 2: {
                return "";
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.length;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWParameterDefinition paramDef = null;
        try {
            paramDef = this.getItemAt(nRowIndex);
            if (paramDef == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return paramDef.getName();
                }
                case 1: {
                    if (paramDef.getIsArray()) {
                        int type = paramDef.getDataType();
                        if (type == 64) {
                            return VWResource.s_workflowGroupStr;
                        }
                        return VWFieldType.getLocalizedString(type) + s_array;
                    }
                    return VWFieldType.getLocalizedString(paramDef.getDataType());
                }
                case 3: {
                    return paramDef.getValue();
                }
                case 2: {
                    return this.getModeTableCellItem(paramDef);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    this.onUpdateFieldValue(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateFieldValue(Object aValue, int nRowIndex) {
        VWParameterDefinition paramDef = null;
        try {
            if (aValue != null) {
                String expression = (String)aValue;
                paramDef = this.getItemAt(nRowIndex);
                if (paramDef != null) {
                    paramDef.setValue(expression);
                    if (this.m_stepDefinition != null) {
                        String[] values = new String[this.m_rowData.length];
                        for (int nIndex = 0; nIndex < this.m_rowData.length; ++nIndex) {
                            values[nIndex] = this.m_rowData[nIndex].getValue();
                        }
                        this.m_stepDefinition.setOperationParameters(values);
                    }
                    this.m_authPropertyData.setDirty();
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWToolTipTableCellItem getModeTableCellItem(VWParameterDefinition paramDef) {
        VWToolTipTableCellItem cellItem = null;
        if (paramDef != null) {
            cellItem = new VWToolTipTableCellItem();
            int mode = paramDef.getMode();
            switch (mode) {
                case 1: {
                    cellItem.setText(VWResource.s_readOnly);
                    cellItem.setIcon(this.m_modeIcons[0]);
                    break;
                }
                case 2: {
                    cellItem.setText(VWResource.s_writeOnly);
                    cellItem.setIcon(this.m_modeIcons[1]);
                    break;
                }
                case 3: {
                    cellItem.setText(VWResource.s_readAndWrite);
                    cellItem.setIcon(this.m_modeIcons[2]);
                }
            }
        }
        return cellItem;
    }
}

